#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_default_theme import pyams_default_theme
from pyams_default_theme.layer import IPyAMSDefaultLayer
from pyams_skin.interfaces import ISkin
from pyams_skin.interfaces.resources import IResources
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.registry import utility_config

from pyams_default_theme import _


@utility_config(name='PyAMS default skin', provides=ISkin)
class PyAMSDefaultSkin(object):
    """PyAMS default skin"""

    label = _("PyAMS default skin")
    layer = IPyAMSDefaultLayer


@adapter_config(context=(Interface, IPyAMSDefaultLayer, Interface), provides=IResources)
class ResourcesAdapter(ContextRequestViewAdapter):
    """PyAMS default skin resources"""

    resources = (pyams_default_theme,)
