#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface
from zope.schema import Bool, Choice, Int
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from pyams_default_theme.features.search.portlet import FULL_HEADER_DISPLAY
from pyams_default_theme.features.search.portlet.interfaces import \
    PANELS_HEADER_DISPLAY_MODES_VOCABULARY


__docformat__ = 'restructuredtext'

from pyams_default_theme import _
from pyams_i18n.schema import I18nTextLineField
from pyams_sequence.interfaces import IInternalReference
from pyams_sequence.schema import InternalReferenceField


VIEW_ITEMS_THUMBNAILS = (
    {'id': '', 'title': _("Initial selection")},
    {'id': 'responsive', 'title': _("Responsive selection")},
    {'id': 'portrait', 'title': _("Portrait selection")},
    {'id': 'pano', 'title': _("Panoramic selection")},
    {'id': 'square', 'title': _("Square selection")}
)

VIEW_ITEMS_THUMBNAILS_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                                     for item in VIEW_ITEMS_THUMBNAILS])


class IViewItemsPortletVerticalRendererSettings(IInternalReference):
    """View items portlet vertical renderer settings interface"""

    display_illustrations = Bool(title=_("Display illustrations?"),
                                 description=_("If 'no', view contents will not display "
                                               "illustrations"),
                                 required=True,
                                 default=True)

    thumbnails_selection = Choice(title=_("Thumbnails selection"),
                                  description=_("Selection used to display images thumbnails"),
                                  vocabulary=VIEW_ITEMS_THUMBNAILS_VOCABULARY,
                                  required=False,
                                  default='')

    display_breadcrumbs = Bool(title=_("Display breadcrumbs?"),
                               description=_("If 'no', view items breadcrumbs will not be "
                                             "displayed"),
                               required=True,
                               default=True)

    display_tags = Bool(title=_("Display tags?"),
                        description=_("If 'no', view items tags will not be displayed"),
                        required=True,
                        default=True)

    paginate = Bool(title=_("Paginate?"),
                    description=_("If 'no', results pagination will be disabled"),
                    required=True,
                    default=True)

    page_size = Int(title=_("Page size"),
                    description=_("Number of items per page, if pagination is enabled"),
                    required=False,
                    default=10)

    reference = InternalReferenceField(title=_("'See all' link target"),
                                       description=_("Internal reference to site or search "
                                                     "folder displaying full list of view's "
                                                     "contents"),
                                       required=False)

    link_label = I18nTextLineField(title=_("Link label"),
                                   description=_("Label of the link to full list page"),
                                   required=False)


class IViewItemsPortletHorizontalRendererSettings(Interface):
    """View items portlet horizontal renderer settings interface"""

    thumbnails_selection = Choice(title=_("Thumbnails selection"),
                                  description=_("Selection used to display images thumbnails"),
                                  vocabulary=VIEW_ITEMS_THUMBNAILS_VOCABULARY,
                                  required=True,
                                  default='portrait')


class IViewItemsPortletSummaryRendererSettings(Interface):
    """View items portlet summary renderer settings interface"""

    display_illustrations = Bool(title=_("Display illustrations?"),
                                 description=_("If 'no', view contents will not display "
                                               "illustrations"),
                                 required=True,
                                 default=True)

    thumbnails_selection = Choice(title=_("Thumbnails selection"),
                                  description=_("Selection used to display images thumbnails"),
                                  vocabulary=VIEW_ITEMS_THUMBNAILS_VOCABULARY,
                                  required=True,
                                  default='pano')

    paginate = Bool(title=_("Paginate?"),
                    description=_("If 'no', results pagination will be disabled"),
                    required=True,
                    default=True)

    page_size = Int(title=_("Page size"),
                    description=_("Number of items per page, if pagination is enabled"),
                    required=False,
                    default=9)

    header_display_mode = Choice(title=_("Header display mode"),
                                 description=_("Defines how results headers will be rendered"),
                                 required=True,
                                 vocabulary=PANELS_HEADER_DISPLAY_MODES_VOCABULARY,
                                 default=FULL_HEADER_DISPLAY)

    start_length = Int(title=_("Start length"),
                       description=_("If you choose to display only header start, you can specify "
                                     "maximum text length"),
                       required=True,
                       default=120)
