#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.shared.view.interfaces import IWfView
from pyams_default_theme.page import BasePreviewPage
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='preview.html', context=IWfView, layer=IPyAMSUserLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@template_config(template='templates/render.pt', layer=IPyAMSUserLayer)
class ViewPreviewPage(BasePreviewPage):
    """Shared view preview page"""

    @property
    def items(self):
        return self.context.get_results(self.context, ignore_cache=True, request=self.request)
