#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.container.contained import Contained
from zope.interface import Interface
from zope.schema.fieldproperty import FieldProperty

from pyams_content.shared.site.interfaces import ISiteContainer
from pyams_default_theme.interfaces import IContentSummaryInfo
from pyams_content.shared.site.portlet import ISiteContainerSummaryPortletSettings
from pyams_default_theme.shared.site.portlet.interfaces import \
    ISiteContainerSummaryRendererSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config

from pyams_default_theme import _


@factory_config(provided=ISiteContainerSummaryRendererSettings)
class SiteContainerSummaryRendererSettings(Persistent, Contained):
    """Site container summary renderer settings"""

    display_header = FieldProperty(ISiteContainerSummaryRendererSettings['display_header'])


class BaseSiteSummaryPortletRenderer(PortletRenderer):
    """Base site summary portlet renderer"""

    @property
    def visible_items(self):
        container = ISiteContainer(self.context, None)
        if container is not None:
            request = self.request
            registry = request.registry
            yield from filter(lambda x: x is not None,
                              map(lambda x: registry.queryMultiAdapter((x, request),
                                                                       IContentSummaryInfo),
                                  container.get_visible_items(request)))


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, ISiteContainerSummaryPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/site-summary.pt', layer=IPyAMSLayer)
class SiteContainerSummaryPortletDefaultRenderer(BaseSiteSummaryPortletRenderer):
    """Site container summary portlet default renderer"""

    label = _("Site container summary")
    weight = 1

    settings_interface = ISiteContainerSummaryRendererSettings


@adapter_config(name='summary-panels',
                context=(IPortalContext, IPyAMSLayer, Interface, ISiteContainerSummaryPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/site-panels.pt', layer=IPyAMSLayer)
class SiteContainerSummaryPortletPanelsRenderer(BaseSiteSummaryPortletRenderer):
    """Site container summary portlet panels renderer"""

    label = _("Three vertical panels with panoramic illustrations")
    weight = 2

    settings_interface = ISiteContainerSummaryRendererSettings


@adapter_config(name='summary-panels-vertical',
                context=(IPortalContext, IPyAMSLayer, Interface, ISiteContainerSummaryPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/site-panels-vertical.pt', layer=IPyAMSLayer)
class SiteContainerSummaryPortletVerticalPanelsRenderer(BaseSiteSummaryPortletRenderer):
    """Site container summary portlet with vertical illustrations renderer"""

    label = _("Four vertical panels with portrait illustrations")
    weight = 3

    settings_interface = ISiteContainerSummaryRendererSettings
