#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from pyramid.httpexceptions import HTTPSeeOther

from pyams_content.shared.site.interfaces import SITE_CONTAINER_REDIRECT_MODE, ISiteManager
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.views import PortalContextIndexPage, PortalContextPreviewPage
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_utils.url import relative_url


@pagelet_config(name='', context=ISiteManager, layer=IPyAMSUserLayer)
class SiteManagerIndexPage(PortalContextIndexPage):
    """Site manager index page"""

    def __call__(self, **kwargs):
        if self.context.navigation_mode == SITE_CONTAINER_REDIRECT_MODE:
            target = next(self.context.get_visible_items(self.request), None)
            if target is not None:
                return HTTPSeeOther(relative_url(target, request=self.request))
        return super().__call__(**kwargs)


@pagelet_config(name='preview.html', context=ISiteManager, layer=IPyAMSUserLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class SiteManagerPreviewPage(PortalContextPreviewPage):
    """Site manager preview page"""

    def __call__(self, **kwargs):
        if self.context.navigation_mode == SITE_CONTAINER_REDIRECT_MODE:
            target = next(self.context.get_visible_items(self.request), None)
            if target is not None:
                return HTTPSeeOther(relative_url(target, request=self.request,
                                                 view_name='preview.html'))
        return super().__call__(**kwargs)
