#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.shared.site.interfaces import ISiteContainer
from pyams_i18n.interfaces import II18n
from pyams_skin.interfaces.viewlet import IBreadcrumbItem
from pyams_skin.layer import IPyAMSUserLayer
from pyams_skin.viewlet.breadcrumb import BreadcrumbItem
from pyams_utils.adapter import adapter_config


@adapter_config(context=(ISiteContainer, IPyAMSUserLayer), provides=IBreadcrumbItem)
class SiteContainerBreadcumbAdapter(BreadcrumbItem):
    """Site container breadcrumb adapter"""

    @property
    def label(self):
        return II18n(self.context).query_attribute('short_name', request=self.request)
