#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.decorator import reify
from zope.interface import Interface

from pyams_content.component.theme import ICollectionsInfo
from pyams_content.features.search.interfaces import ISearchManagerInfo
from pyams_content.shared.resource import IAgeRange, IResourceInfo, IWfResource
from pyams_default_theme import lightbox
from pyams_default_theme.features.search.portlet import ISearchResultHeader, \
    ISearchResultRenderer, WfSharedContentSearchResultRenderer
from pyams_default_theme.interfaces import ISearchResultsView
from pyams_default_theme.shared.common.interfaces import \
    ICustomContentSpecificitiesParagraphRenderer, ICustomContentSpecificitiesRenderer
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.text import text_to_html
from pyams_viewlet.viewlet import ViewContentProvider


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


@adapter_config(context=(IWfResource, IPyAMSUserLayer, Interface),
                provides=ICustomContentSpecificitiesRenderer)
@adapter_config(context=(IWfResource, IPyAMSUserLayer, Interface),
                provides=ICustomContentSpecificitiesParagraphRenderer)
@template_config(template='templates/specificities.pt', layer=IPyAMSUserLayer)
class ResourceSpecificitiesPortletRenderer(ViewContentProvider):
    """Resource specificities portlet renderer"""

    resources = (lightbox,)

    @property
    def resource_info(self):
        return IResourceInfo(self.context)

    @property
    def collections(self):
        collections_info = ICollectionsInfo(self.context, None)
        if collections_info is not None:
            collections = collections_info.collections or ()
            yield from sorted(collections, key=lambda x: (x.order or 999, x.alt or x.label))

    @reify
    def search_target(self):
        search_info = ISearchManagerInfo(self.request.root, None)
        if search_info is not None:
            return search_info.collections_target

    def get_age_range(self, value: IAgeRange):
        translate = self.request.localizer.translate
        if value.min_value and value.max_value:
            result = _("from {0.min_value} to {0.max_value}")
        elif value.min_value:
            result = _("from {0.min_value}")
        else:
            result = _("up to {0.max_value}")
        return translate(result).format(value)


@adapter_config(context=(IWfResource, IPyAMSUserLayer, ISearchResultsView), provides=ISearchResultHeader)
def resource_search_result_header_adapter(context, request, view):
    """Resource search result header adapter"""
    header = II18n(context).query_attribute('header', request=request)
    if header:
        return text_to_html(header)
    else:
        return ''


@adapter_config(context=(IWfResource, IPyAMSUserLayer, ISearchResultsView), provides=ISearchResultRenderer)
@template_config(template='templates/search-result.pt', layer=IPyAMSUserLayer)
class WfResourceSearchResultRenderer(WfSharedContentSearchResultRenderer):
    """Resource search result renderer"""
