#
# Copyright (c) 2015-2020 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_default_theme.shared.logo.skin interfaces module

"""

from zope.interface import Interface
from zope.schema import Bool, Choice
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


DISABLED_LINK = 'disabled'
INTERNAL_FIRST = 'internal'
EXTERNAL_FIRST = 'external'

TARGET_PRIORITY = (
    {'id': DISABLED_LINK, 'title': _("Disabled link")},
    {'id': INTERNAL_FIRST, 'title': _("Use internal reference first")},
    {'id': EXTERNAL_FIRST, 'title': _("Use external URL first")}
)

TARGET_PRIORITY_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                               for item in TARGET_PRIORITY])


class ILogosParagraphRendererSettings(Interface):
    """Logos paragraph renderer settings"""

    target_priority = Choice(title=_("Links priority"),
                             description=_("Order in which internal and external links are "
                                           "evaluated"),
                             required=True,
                             vocabulary=TARGET_PRIORITY_VOCABULARY,
                             default=EXTERNAL_FIRST)

    force_canonical_url = Bool(title=_("Force canonical URL"),
                               description=_("By default, internal links use a \"relative\" URL, "
                                             "which tries to display link target in the current "
                                             "context; by using a canonical URL, you can display "
                                             "target in it's attachment context (if defined)"),
                               required=False,
                               default=False)
