#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.shared.imagemap.portlet import IImageMapPortletSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IImageMapPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/imagemap-default.pt', layer=IPyAMSLayer)
class ImageMapPortletDefaultRenderer(PortletRenderer):
    """Image map portlet default renderer"""

    label = _("Responsive SVG image map")
    weight = 1

    def get_item_info(self, item):
        return IAssociationInfo(item, None)
