#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface, invariant, Invalid
from zope.schema import Choice


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


class IImageMapParagraphDefaultRendererSettings(Interface):
    """Image map paragraph default renderer settings interface"""

    width = Choice(title=_("Paragraph width"),
                   description=_("Width of the image map relative to it's parent portlet"),
                   values=(12, 11, 10, 9, 8, 7, 6, 5, 4),
                   default=12)

    offset = Choice(title=_("Left offset"),
                    description=_("Left offset width, relative to it's parent portlet"),
                    values=(0, 1, 2, 3, 4, 5, 6, 7, 8),
                    default=0)

    @invariant
    def check_offset(self):
        if (self.width + self.offset) > 12:
            raise Invalid(_("Sum of width and offset shouldn't be higher than 12!"))
