#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from persistent import Persistent
from zope.container.contained import Contained
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_content.shared.imagemap.interfaces import IImageMapParagraph, IWfImageMap
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_default_theme.page import BasePreviewPage
from pyams_default_theme.shared.imagemap.interfaces import IImageMapParagraphDefaultRendererSettings
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer, IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


#
# Imagemap preview
#

@pagelet_config(name='preview.html', context=IWfImageMap, layer=IPyAMSUserLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@template_config(template='templates/render.pt', layer=IPyAMSLayer)
class ImageMapPreviewer(BasePreviewPage):
    """Image map preview renderer"""

    def get_item_info(self, item):
        return IAssociationInfo(item, None)


#
# Imagemap paragraph renderer
#

IMAGEMAP_DEFAULT_RENDERER_SETTINGS_KEY = 'pyams_content.imagemap.renderer:default'


@factory_config(IImageMapParagraphDefaultRendererSettings)
class ImageMapParagraphDefaultRendererSettings(Persistent, Contained):
    """Image map paragraph default renderer settings"""

    width = FieldProperty(IImageMapParagraphDefaultRendererSettings['width'])
    offset = FieldProperty(IImageMapParagraphDefaultRendererSettings['offset'])


@adapter_config(context=IImageMapParagraph, provides=IImageMapParagraphDefaultRendererSettings)
def imagemap_paragraph_default_renderer_settings_factory(context):
    """Image map paragraph default renderer settings factory"""
    return get_annotation_adapter(context, IMAGEMAP_DEFAULT_RENDERER_SETTINGS_KEY,
                                  IImageMapParagraphDefaultRendererSettings)


@adapter_config(name='default', context=(IImageMapParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/imagemap-default.pt', layer=IPyAMSLayer)
class ImageMapParagraphDefaultRenderer(BaseContentRenderer):
    """Image map default paragraph renderer"""

    label = _("Default imagemap renderer")
    settings_interface = IImageMapParagraphDefaultRendererSettings

    i18n_context_attrs = ('title',)

    def get_item_info(self, item):
        return IAssociationInfo(item, None)
