#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_content.shared.form import IWfForm
from pyams_content.shared.form.interfaces import IFormFieldsParagraph
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_default_theme.shared.form import FormFieldContainerInputForm
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.traversing import get_parent


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


@adapter_config(name='default', context=(IFormFieldsParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/form-fields.pt', layer=IPyAMSLayer)
class FormFieldsParagraphDefaultRenderer(BaseContentRenderer):
    """Form fields paragraph default renderer"""

    label = _("Default form fields renderer")
    weight = 1

    i18n_context_attrs = ('title', )

    input_form = None

    def __init__(self, context, request):
        super(FormFieldsParagraphDefaultRenderer, self).__init__(context, request)
        form = get_parent(context, IWfForm)
        if form is not None:
            self.input_form = FormFieldContainerInputForm(form, self.request)

    def update(self):
        super(FormFieldsParagraphDefaultRenderer, self).update()
        if self.input_form is not None:
            self.input_form.update()

    def render(self, template_name=''):
        if self.input_form is None:
            return ''
        return super().render(template_name)
