#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_default_theme.shared.form.captcha module

"""

from zope.interface import Interface

from pyams_content.shared.form import IFormFieldContainerTarget, IWfForm
from pyams_content.shared.form.interfaces import IFormFieldContainerInputForm
from pyams_default_theme.layer import IPyAMSDefaultLayer
from pyams_default_theme.shared.form import FormFieldContainerInputForm
from pyams_form.interfaces import IForm
from pyams_form.interfaces.form import IFormSuffixViewletsManager
from pyams_template.template import template_config
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces.tales import ITALESExtension
from pyams_viewlet.viewlet import Viewlet, viewlet_config


__docformat__ = 'restructuredtext'


@viewlet_config(name='recaptcha',
                context=IFormFieldContainerTarget,
                layer=IPyAMSDefaultLayer,
                view=FormFieldContainerInputForm,
                manager=IFormSuffixViewletsManager)
@template_config(template='templates/recaptcha.pt',
                 layer=IPyAMSDefaultLayer)
class FormCaptchaViewlet(Viewlet):
    """Form captcha viewlet"""

    def __new__(cls, context, request, view, manager):
        settings = context.get_captcha_settings()
        if not settings.get('use_captcha'):
            return None
        return Viewlet.__new__(cls)


@adapter_config(name='recaptcha.client_key',
                context=(Interface, IPyAMSDefaultLayer, IForm),
                provides=ITALESExtension)
class CaptchaClientKeyTALESExtension(ContextRequestViewAdapter):
    """Captcha client key TALES extension"""

    def render(self, context=None):
        if context is None:
            context = self.request.context
        form = IWfForm(context, None)
        if form is None:
            return None
        settings = form.get_captcha_settings()
        if not settings.get('use_captcha'):
            return None
        return settings.get('client_key')
