#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.shared.common.interfaces.types import IWfTypedSharedContent
from pyams_default_theme.shared.common.url import WfSharedContentCanonicalUrlAdapter
from pyams_default_theme.viewlet.breadcrumb import BreadcrumbsAdapter
from pyams_sequence.interfaces import ISequentialIdInfo
from pyams_skin.interfaces.viewlet import IBreadcrumbs
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces.url import ICanonicalURL
from pyams_utils.url import absolute_url


@adapter_config(context=(IWfTypedSharedContent, IPyAMSUserLayer), provides=ICanonicalURL)
class TypedSharedContentCanonicalUrlAdapter(WfSharedContentCanonicalUrlAdapter):
    """Typed shared content canonical URL adapter"""

    def get_url(self, view_name=None, query=None):
        data_type = self.context.get_data_type()
        if data_type is not None:
            source = data_type.get_source_folder()
            if source is not None:
                return absolute_url(source, self.request,
                                    '+/{0}::{1}{2}{3}'.format(
                                        ISequentialIdInfo(self.context).get_base_oid().strip(),
                                        self.context.content_url,
                                        '/{}'.format(view_name) if view_name else '.html',
                                        '?{}'.format(query) if query else ''))
        return super(TypedSharedContentCanonicalUrlAdapter, self).get_url(view_name, query)


@adapter_config(context=(IWfTypedSharedContent, IPyAMSUserLayer, Interface), provides=IBreadcrumbs)
class TypedSharedContentBreadcrumbsAdapter(BreadcrumbsAdapter):
    """Typed shared content breadcrumbs adapter"""

    @property
    def items(self):
        data_type = self.context.get_data_type()
        if data_type is not None:
            source = data_type.get_source_folder()
            if source is not None:
                yield from self.get_items(source)
                return
        yield from super(TypedSharedContentBreadcrumbsAdapter, self).items
