#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.shared.common import ISharedContent, IWfSharedContent
from pyams_default_theme.interfaces import IContentSummaryInfo
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.adapter import ContextRequestAdapter, adapter_config

from pyams_default_theme import _


@adapter_config(context=(IWfSharedContent, IPyAMSUserLayer), provides=IContentSummaryInfo)
class WfSharedContentSummaryInfo(ContextRequestAdapter):
    """Shared content summary info adapter"""

    @property
    def title(self):
        return II18n(self.context).query_attribute('title', request=self.request)

    @property
    def header(self):
        return II18n(self.context).query_attribute('header', request=self.request)

    @property
    def button_title(self):
        return _("Consult content")


@adapter_config(context=(ISharedContent, IPyAMSUserLayer), provides=IContentSummaryInfo)
def shared_content_summary_adapter(context, request):
    """Shared content summary adapter"""
    version = context.visible_version
    if version is not None:
        return request.registry.queryMultiAdapter((version, request), IContentSummaryInfo)
