#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_content.shared.common import IWfSharedContent
from pyams_content.shared.common.interfaces.specificities import \
    ISharedContentSpecificitiesParagraph
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_default_theme.shared.common.interfaces import \
    ICustomContentSpecificitiesParagraphRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.traversing import get_parent

from pyams_default_theme import _


#
# Shared content specificities paragraph renderer
#

@adapter_config(name='default', context=(ISharedContentSpecificitiesParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/specificities-paragraph.pt', layer=IPyAMSLayer)
class SharedContentSpecificitiesParagraphRenderer(BaseContentRenderer):
    """Default shared content specificities paragraph renderer"""

    label = _("Default specificities paragraph renderer")

    renderer = None

    def update(self):
        super(SharedContentSpecificitiesParagraphRenderer, self).update()
        context = get_parent(self.context, IWfSharedContent)
        if context is not None:
            registry = self.request.registry
            self.renderer = renderer = registry.queryMultiAdapter(
                (context, self.request, self), ICustomContentSpecificitiesParagraphRenderer)
            if renderer is not None:
                renderer.update()

    def render(self, template_name=''):
        return '' if self.renderer is None else \
            super().render(template_name)
