
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from pyams_content.shared.common.portlet.interfaces import ISharedContentTitlePortletSettings
from pyams_default_theme.interfaces import IContentTitle
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer, IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import contentprovider_config, ViewContentProvider


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


@contentprovider_config(name='pyams_content.title', layer=IPyAMSUserLayer, view=Interface)
@template_config(template='templates/title.pt')
class SharedContentTitleProvider(ViewContentProvider):
    """Shared content title viewlet"""

    @property
    def title(self):
        return self.request.registry.queryMultiAdapter((self.context, self.request),
                                                       IContentTitle)


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface,
                         ISharedContentTitlePortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/title-portlet.pt', layer=IPyAMSLayer)
class SharedContentTitlePortletRenderer(PortletRenderer):
    """Shared content title portlet renderer"""

    label = _("Default title renderer")

    @property
    def title(self):
        return self.request.registry.queryMultiAdapter((self.context, self.request),
                                                       IContentTitle)
