#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.shared.common.portlet.interfaces import \
    ISharedContentSpecificitiesPortletSettings
from pyams_default_theme import _
from pyams_default_theme.shared.common.interfaces import ICustomContentSpecificitiesRenderer
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config


#
# Shared content specificities portlet renderer
#

@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface,
                         ISharedContentSpecificitiesPortletSettings),
                provides=IPortletRenderer)
class SharedContentSpecificitiesPortletRenderer(PortletRenderer):
    """Shared content specificities portlet default renderer"""

    label = _("Default specificities renderer")

    renderer = None

    def update(self):
        super(SharedContentSpecificitiesPortletRenderer, self).update()
        registry = self.request.registry
        self.renderer = renderer = registry.queryMultiAdapter(
            (self.context, self.request, self.view), ICustomContentSpecificitiesRenderer)
        if renderer is not None:
            renderer.update()

    def render(self, template_name=''):
        return '' if self.renderer is None else self.renderer.render(template_name)
