
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface, implementer

from pyams_content.shared.common.portlet.interfaces import ISharedContentHeaderPortletSettings
from pyams_default_theme.shared.common.interfaces import ISharedContentHeadViewletManager
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer, IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_viewlet.manager import WeightOrderedViewletManager, viewletmanager_config

from pyams_default_theme import _


@viewletmanager_config(name='pyams_content.head', layer=IPyAMSUserLayer, view=Interface)
@implementer(ISharedContentHeadViewletManager)
class SharedContentHeadViewletManager(WeightOrderedViewletManager):
    """Shared content head viewlet manager"""


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, ISharedContentHeaderPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/head.pt', layer=IPyAMSLayer)
class SharedContentHeaderPortletRenderer(PortletRenderer):
    """Shared content header portlet renderer"""

    label = _("Default header renderer")
