#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.interfaces import IBaseContent
from pyams_content.shared.common import ISharedContent
from pyams_content.shared.site import ISiteElementNavigation
from pyams_default_theme.interfaces import IContentHeader, IContentNavigationTitle
from pyams_i18n.interfaces import II18n
from pyams_sequence.interfaces import IInternalReference
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.adapter import ContextRequestAdapter, ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces.tales import ITALESExtension
from pyams_workflow.interfaces import IWorkflowPublicationInfo


@adapter_config(context=(IBaseContent, IPyAMSUserLayer),
                provides=IContentNavigationTitle)
def shared_content_navigation_title(context, request):
    """Default content navigation title adapter"""
    return II18n(context).query_attribute('title', request=request)


@adapter_config(context=(IInternalReference, IPyAMSUserLayer),
                provides=IContentNavigationTitle)
def internal_link_content_navigation_title(context, request):
    """Internal link content navigation title adapter"""
    registry = request.registry
    return registry.queryMultiAdapter((context.target, request), IContentNavigationTitle)


@adapter_config(name='pyams_title',
                context=(Interface, Interface, Interface),
                provides=ITALESExtension)
class PyAMSContentTitleTALESExtension(ContextRequestViewAdapter):
    """PyAMS content title TALES extension"""

    def render(self, context=None):
        if context is None:
            context = self.context
        return self.request.registry.queryMultiAdapter((context, self.request),
                                                       IContentNavigationTitle)


@adapter_config(name='pyams_header',
                context=(Interface, Interface, Interface),
                provides=ITALESExtension)
class PyAMSContentHeaderTALESExtension(ContextRequestViewAdapter):
    """PyAMS content header TALES extension"""

    def render(self, context=None):
        if context is None:
            context = self.context
        return self.request.registry.queryMultiAdapter((context, self.request),
                                                       IContentHeader)


@adapter_config(context=(ISharedContent, IPyAMSUserLayer),
                provides=ISiteElementNavigation)
class SharedContentNavigationAdapter(ContextRequestAdapter):
    """Shared content navigation adapter"""

    @property
    def visible(self):
        version = self.context.visible_version
        if version is not None:
            return IWorkflowPublicationInfo(version).is_visible(self.request)
