#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.contentprovider.interfaces import IContentProvider
from zope.interface import Interface


class ICustomContentHeaderRenderer(IContentProvider):
    """Custom content header renderer"""


class ICustomContentSpecificitiesRenderer(IContentProvider):
    """Custom content specificities renderer"""


class ICustomContentSpecificitiesParagraphRenderer(IContentProvider):
    """Custom content specificities paragraph renderer"""


class ISharedContentHeadViewletManager(Interface):
    """Shared content head viewlet manager marker interface"""


class IPublicURL(Interface):
    """Public URL target getter interface"""

    def get_url(self):
        """URL getter"""
