#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_default_theme.shared.common.interfaces import ICustomContentHeaderRenderer
from pyams_skin.layer import IPyAMSUserLayer
from pyams_viewlet.viewlet import contentprovider_config, ViewContentProvider


@contentprovider_config(name='pyams_content.custom_header', layer=IPyAMSUserLayer, view=Interface)
class CustomContentHeaderContentProvider(ViewContentProvider):
    """Custom content header"""

    renderer = None

    def update(self):
        super(CustomContentHeaderContentProvider, self).update()
        registry = self.request.registry
        self.renderer = renderer = registry.queryMultiAdapter(
            (self.context, self.request, self.view), ICustomContentHeaderRenderer)
        if renderer is not None:
            renderer.update()

    def render(self, template_name=''):
        return '' if self.renderer is None else self.renderer.render(template_name)
