#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.shared.blog import IWfBlogPost
from pyams_content.shared.blog.interfaces import IBlogFolder
from pyams_sequence.interfaces import ISequentialIdInfo
from pyams_skin.layer import IPyAMSUserLayer
from pyams_utils.adapter import ContextRequestAdapter, adapter_config
from pyams_utils.interfaces.url import ICanonicalURL
from pyams_utils.traversing import get_parent
from pyams_utils.url import absolute_url


@adapter_config(context=(IWfBlogPost, IPyAMSUserLayer), provides=ICanonicalURL)
class BlogPostCanonicalUrlAdapter(ContextRequestAdapter):
    """Blog post canonical URL adapter"""

    def get_url(self, view_name=None, query=None):
        parent = get_parent(self.context, IBlogFolder)
        return absolute_url(parent, self.request,
                            '+/{0}::{1}{2}{3}'.format(
                                ISequentialIdInfo(self.context).get_base_oid().strip(),
                                self.context.content_url,
                                '/{}'.format(view_name) if view_name else '.html',
                                '?{}'.format(query) if query else ''))
