(function($, globals) {

	"use strict";

	var ams = globals.MyAMS;
	globals.PyAMS_default = {

		search: {

			updateSort: function() {
				var form = $('form[id="search-results"]');
				if (form.exists()) {
					var index = $(this).val();
					$('input[name="order_by"]', form).val(index);
					form.submit();
				}
			},

			updatePageLength: function() {
				var form = $('form[id="search-results"]');
				if (form.exists()) {
					var length = $(this).val();
					$('input[name="start"]', form).val(0);
					$('input[name="length"]', form).val(length);
					form.submit();
				}
			},

			previousPage: function() {
				var form = $('form[id="search-results"]');
				if (form.exists()) {
					var current = $(this).parents('ol.pagination').data('ams-current-page');
					var length = $('input[name="length"]', form).val();
					$('input[name="start"]', form).val(length * (current - 2));
					form.submit();
				}
			},

			nextPage: function() {
				var form = $('form[id="search-results"]');
				if (form.exists()) {
					var current = $(this).parents('ol.pagination').data('ams-current-page');
					var length = $('input[name="length"]', form).val();
					$('input[name="start"]', form).val(length * current);
					form.submit();
				}
			},

			gotoPage: function() {
				var form = $('form[id="search-results"]');
				if (form.exists()) {
					var target = parseInt($(this).text());
					var length = $('input[name="length"]', form).val();
					$('input[name="start"]', form).val(length * (target - 1));
					form.submit();
				}
			}
		}
	};

	/**
	 * Init lightbox plug-in
	 */
	$(document).on('click', '[data-toggle="lightbox"]', function (event) {
		event.preventDefault();
		var source = $(this);
		ams.ajax.check($.fn.ekkoLightbox,
					   '/--static--/pyams_default_theme/js/ext/ekko-lightbox' + ams.devext + '.js',
					   function() {
							source.ekkoLightbox({
								wrapping: false,
								alwaysShowClose: true,
								onContentLoaded: function() {
									var element = this.element(),
										description = element.data('description'),
										modal = this.modal(),
										container = $('.ekko-lightbox-container', modal);
									$('.description', container).remove();
									if (description) {
										$('<div></div>').addClass('description')
														.text(description)
														.appendTo(container);
									}
								}
							});
					   });
	});

	/**
	 * Initialize MyAMS custom click handlers
	 */
	$(document).on('click', '[data-ams-click-handler]', function(event) {
		var source = $(this);
		var handlers = source.data('ams-disabled-handlers');
		if ((handlers === true) || (handlers === 'click') || (handlers === 'all')) {
			return;
		}
		var data = source.data();
		if (data.amsClickHandler) {
			if ((data.amsStopPropagation === true) || (data.amsClickStopPropagation === true)) {
				event.stopPropagation();
			}
			if (data.amsClickKeepDefault !== true) {
				event.preventDefault();
			}
			var clickHandlers = data.amsClickHandler.split(/\s+/);
			for (var index=0; index < clickHandlers.length; index++) {
				var callback = ams.getFunctionByName(clickHandlers[index]);
				if (callback !== undefined) {
					callback.call(source, event, data.amsClickHandlerOptions);
				}
			}
		}
	});

	/**
	 * Initialize MyAMS custom change handlers
 	 */
	$(document).on('change', '[data-ams-change-handler]', function(event) {
		var source = $(this);
		// Disable change handlers for readonly inputs
		// These change handlers are activated by IE!!!
		if (source.prop('readonly')) {
			return;
		}
		var handlers = source.data('ams-disabled-handlers');
		if ((handlers === true) || (handlers === 'change') || (handlers === 'all')) {
			return;
		}
		var data = source.data();
		if (data.amsChangeHandler) {
			if ((data.amsStopPropagation === true) || (data.amsChangeStopPropagation === true)) {
				event.stopPropagation();
			}
			if (data.amsChangeKeepDefault !== true) {
				event.preventDefault();
			}
			var changeHandlers = data.amsChangeHandler.split(/\s+/);
			for (var index=0; index < changeHandlers.length; index++) {
				var callback = ams.getFunctionByName(changeHandlers[index]);
				if (callback !== undefined) {
					callback.call(source, event, data.amsChangeHandlerOptions);
				}
			}
		}
	});

	/**
	 * Videos sources updates
	 *
	 * Update videos sources based on current screen resolution
	 */
	function resetVideosSources() {
		var videos = $('video');
		if (videos.length > 0) {
			var width;
			if (window.matchMedia === undefined) {
				width = (window.innerWidth > 0) ? window.innerWidth : screen.width
			}
			videos.each(function(idx, elt) {
				var video = $(elt),
					position = elt.currentTime || 0,
					sources = video.data('ams-sources'),
					loaded = {};
				if (sources) {
					video.empty();
					for (var idxSrc in sources) {
						if (!sources.hasOwnProperty(idxSrc)) {
							continue;
						}
						var source = sources[idxSrc],
							type = source.type,
							condition;
						if (loaded[type] !== undefined) {
							continue;
						}
						if (window.matchMedia === undefined) {
							condition = (source.min < width);
							if (condition && source.max) {
								condition = (width <= source.max);
							}
						} else {
							var min = source.min ? '(min-device-width: ' + source.min + 'px)' : '',
								max = source.max ? '(max-device-width: ' + source.max + 'px)' : '',
								query = min + ((min && max) ? ' and ' : '') + max;
							condition = window.matchMedia(query).matches;
						}
						if (condition) {
							$('<source>').attr('type', type)
								.attr('src', source.src)
								.appendTo(video);
							loaded[type] = true;
						}
					}
					elt.currentTime = position;
				}
			});
		}
	}
	resetVideosSources();
	window.addEventListener('resize', resetVideosSources);

	/**
	 * Glossary terms access
	 */
	var clickTerm = function() {
		var modal = $('.modal >div');
		if (modal.exists()) {
			ams.dialog.close(modal);
		}
		var term = $(this).data('term') || $(this).text();
		ams.dialog.open('/get-glossary-term.html?term=' + term, {}, {
			shown: function() {
				$('.thesaurus-term').off('click').on('click', clickTerm);
			}
		});
	};

	ams.require(['error', 'ajax', 'dialog'], function () {
		$('.thesaurus-term').off('click').on('click', clickTerm);
	});

})(jQuery, this);
