#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface, Attribute


class IContentTitle(Interface):
    """Content title"""


class IContentNavigationTitle(Interface):
    """Content navigation title"""


class IContentTag(Interface):
    """Content tag interface"""


class IContentDate(Interface):
    """Content date interface"""


class IContentHeader(Interface):
    """Content header interface"""


class IContentBannerIllustration(Interface):
    """Content banner illustration adapter interface"""


class IContentHeaderIllustration(Interface):
    """Content header illustration adapter interface"""


class IContentNavigationIllustration(Interface):
    """Content navigation illustration adapter interface"""


class IContentSummaryInfo(Interface):
    """Content interface for site summary page"""

    context = Attribute("Link to adapted context")

    title = Attribute("Content's title")

    header = Attribute("Header")

    button_title = Attribute("Button's target")


class ISearchResultsView(Interface):
    """Search results view marker interface"""


class ISearchResultsPanelView(ISearchResultsView):
    """Search results panel view marker interface"""
