#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.component.illustration import IIllustration
from pyams_content.features.thesaurus import IThesaurusTermHTMLInfo
from pyams_default_theme.features.thesaurus.interfaces import IThesaurusTermRenderer
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSUserLayer
from pyams_template.template import template_config
from pyams_thesaurus.interfaces.term import IThesaurusTerm
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import ViewContentProvider


@adapter_config(name='header',
                context=(IThesaurusTerm, IPyAMSUserLayer, Interface),
                provides=IThesaurusTermRenderer)
@template_config(template='templates/header.pt', layer=IPyAMSUserLayer)
class ThesaurusTermHeaderRenderer(ViewContentProvider):
    """Thesaurus term header renderer"""

    weight = 5


@adapter_config(name='illustration',
                context=(IThesaurusTerm, IPyAMSUserLayer, Interface),
                provides=IThesaurusTermRenderer)
@template_config(template='templates/illustration.pt', layer=IPyAMSUserLayer)
class ThesaurusTermIllustrationRenderer(ViewContentProvider):
    """Thesaurus term illustration renderer"""

    weight = 10

    illustration = None

    def update(self):
        super(ThesaurusTermIllustrationRenderer, self).update()
        self.illustration = IIllustration(self.context, None)


@adapter_config(name='html',
                context=(IThesaurusTerm, IPyAMSUserLayer, Interface),
                provides=IThesaurusTermRenderer)
@template_config(template='templates/html.pt', layer=IPyAMSUserLayer)
class ThesaurusTermHtmlRenderer(ViewContentProvider):
    """Thesaurus term HTML renderer"""

    weight = 20

    html = None

    def update(self):
        super(ThesaurusTermHtmlRenderer, self).update()
        info = IThesaurusTermHTMLInfo(self.context, None)
        if info is not None:
            self.html = II18n(info).query_attribute('description', request=self.request)


@adapter_config(name='associated-terms',
                context=(IThesaurusTerm, IPyAMSUserLayer, Interface),
                provides=IThesaurusTermRenderer)
@template_config(template='templates/associated-terms.pt', layer=IPyAMSUserLayer)
class ThesaurusTermAssociatedTermsRenderer(ViewContentProvider):
    """Thesaurus term associated terms renderer"""

    weight = 50


@adapter_config(name='footer',
                context=(IThesaurusTerm, IPyAMSUserLayer, Interface),
                provides=IThesaurusTermRenderer)
@template_config(template='templates/footer.pt', layer=IPyAMSUserLayer)
class ThesaurusTermFooterRenderer(ViewContentProvider):
    """Thesaurus term footer renderer"""

    weight = 90
