#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from myams import awesomefonts_css
from pyams_content.features.share.portlet import IToolboxPortletSettings
from pyams_default_theme import _
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IToolboxPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/toolbox.pt', layer=IPyAMSLayer)
class ToolboxPortletDefaultRenderer(PortletRenderer):
    """Toolbox portlet renderer"""

    label = _("Default toolbox")

    resources = (awesomefonts_css,)
