#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from pyams_content.features.share.interfaces import ISocialShareManager
from pyams_utils.adapter import ContextRequestViewAdapter, adapter_config
from pyams_utils.interfaces.tales import ITALESExtension


@adapter_config(name='social_shares',
                required=(Interface, Interface, Interface),
                provides=ITALESExtension)
class SocialSharesTALESExtension(ContextRequestViewAdapter):
    """Social shares TALES extension"""

    def render(self, context=None):
        manager = ISocialShareManager(self.request.root, None)
        if manager is not None:
            yield from manager.get_active_items()
