#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.decorator import reify
from zope.interface import implementer

from pyams_content.features.renderer import IContentRenderer, IRenderedContent, IRendererSettings
from pyams_content.features.renderer.interfaces import HIDDEN_RENDERER_NAME
from pyams_i18n.interfaces import II18n
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_viewlet.viewlet import BaseContentProvider


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


@implementer(IContentRenderer)
class BaseContentRenderer(BaseContentProvider):
    """Base content renderer"""

    label = None
    weight = 0

    settings_interface = None

    language = None
    context_attrs = ()
    i18n_context_attrs = ()

    @reify
    def settings(self):
        if self.settings_interface is None:
            return None
        return IRendererSettings(self.context)

    def update(self):
        super(BaseContentRenderer, self).update()
        for attr in self.context_attrs:
            setattr(self, attr, getattr(self.context, attr, None))
        if self.i18n_context_attrs:
            i18n = II18n(self.context, None)
            if i18n is not None:
                for attr in self.i18n_context_attrs:
                    setattr(self, attr, i18n.query_attribute(attr, lang=self.language,
                                                             request=self.request))


@adapter_config(name=HIDDEN_RENDERER_NAME,
                context=(IRenderedContent, IPyAMSLayer),
                provides=IContentRenderer)
class HiddenContentRenderer(BaseContentRenderer):
    """Hidden content renderer"""

    label = _("Hidden content")
    weight = -999

    def render(self, template_name=''):
        return ''
