#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.interface import Interface
from zope.location.location import Location
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.association.interfaces import IAssociationInfo
from pyams_content.features.menu.portlet.navigation.interfaces.double import IDoubleNavigationPortletSettings
from pyams_content.features.menu.portlet.navigation.interfaces.simple import ISimpleNavigationPortletSettings
from pyams_default_theme.features.menu.portlet.navigation.interfaces import \
    IDoubleNavigationPortletSelectMenusRendererSettings
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config

from pyams_default_theme import _


class BaseNavigationRenderer(PortletRenderer):
    """Base navigation portlet renderer"""

    @staticmethod
    def get_link_info(link):
        return IAssociationInfo(link)


#
# Simple navigation portlet renderers
#

@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, ISimpleNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/simple-horizontal.pt', layer=IPyAMSLayer)
class SimpleNavigationPortletHorizontalRenderer(BaseNavigationRenderer):
    """Simple navigation horizontal portlet renderer"""

    label = _("Horizontal list with vertical illustrations")
    weight = 1


@adapter_config(name='horizontal-tabs',
                context=(IPortalContext, IPyAMSLayer, Interface, ISimpleNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/simple-horizontal-tabs.pt', layer=IPyAMSLayer)
class SimpleNavigationPortletHorizontalTabsRenderer(BaseNavigationRenderer):
    """Simple navigation horizontal portlet renderer with tabs"""

    label = _("Horizontal list with tabs and horizontal illustrations")
    weight = 2


@adapter_config(name='carousel',
                context=(IPortalContext, IPyAMSLayer, Interface, ISimpleNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/simple-carousel.pt', layer=IPyAMSLayer)
class SimpleNavigationPortletCarouselRenderer(BaseNavigationRenderer):
    """Simple navigation portlet carousel renderer"""

    label = _("Horizontal carousel with full width illustrations")
    weight = 3


@adapter_config(name='vertical-panels',
                context=(IPortalContext, IPyAMSLayer, Interface, ISimpleNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/simple-panels.pt', layer=IPyAMSLayer)
class SimpleNavigationPortletVerticalPanelsRenderer(BaseNavigationRenderer):
    """Simple navigation portlet vertical panels renderer"""

    label = _("Vertical panels with panoramic illustrations")
    weight = 4


#
# Double navigation portlet default renderer
#

@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IDoubleNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/double-vertical.pt', layer=IPyAMSLayer)
class DoubleNavigationPortletDefaultRenderer(PortletRenderer):
    """Double navigation portlet default renderer"""

    label = _("Vertical list with small horizontal menus illustrations")

    @staticmethod
    def get_link_info(link):
        return IAssociationInfo(link)


#
# Double navigation portlet "double-select" renderer
#

@factory_config(provided=IDoubleNavigationPortletSelectMenusRendererSettings)
class DoubleNavigationPortletSelectMenusRendererSettings(Persistent, Location):
    """Double navigation portlet select menus renderer settings"""

    first_level_label = FieldProperty(IDoubleNavigationPortletSelectMenusRendererSettings['first_level_label'])
    second_level_label = FieldProperty(IDoubleNavigationPortletSelectMenusRendererSettings['second_level_label'])


@adapter_config(name='double-select',
                context=(IPortalContext, IPyAMSLayer, Interface, IDoubleNavigationPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/double-select.pt', layer=IPyAMSLayer)
class DoubleNavigationPortletSelectMenusRenderer(PortletRenderer):
    """Double navigation portlet menus renderer"""

    label = _("Double-level selection navigation")

    settings_interface = IDoubleNavigationPortletSelectMenusRendererSettings

    @staticmethod
    def get_link_info(link):
        return IAssociationInfo(link)
