#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from transaction.interfaces import ITransactionManager
from z3c.form import field

from pyams_content.features.header.zmi import HeaderSettingsRendererSettingsEditForm
from pyams_content.features.menu.zmi import IMenusView, MenusTable, MenusView
from pyams_default_theme.features.header import ISimpleHeaderMenusContainer, ISimpleHeaderRendererSettings
from pyams_form.interfaces.form import IInnerSubForm
from pyams_portal.interfaces import MANAGE_TEMPLATE_PERMISSION
from pyams_skin.event import get_json_widget_refresh_event
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm

from pyams_default_theme import _


@adapter_config(name='simple-header-properties',
                context=(ISimpleHeaderRendererSettings, IPyAMSLayer, HeaderSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
class SimpleHeaderPropertiesEditForm(InnerAdminEditForm):
    """Simple header properties edit form"""

    legend = None
    edit_permission = MANAGE_TEMPLATE_PERMISSION
    weight = 1

    fields = field.Fields(ISimpleHeaderRendererSettings)

    def get_ajax_output(self, changes):
        output = super(SimpleHeaderPropertiesEditForm, self).get_ajax_output(changes)
        updated = changes.get(ISimpleHeaderRendererSettings, ())
        if updated:
            ITransactionManager(self.context).commit()
            if 'banner' in updated:
                output.setdefault('events', []).append(
                    get_json_widget_refresh_event(self.context, self.request,
                                                  SimpleHeaderPropertiesEditForm, 'banner'))
            if 'logo' in updated:
                output.setdefault('events', []).append(
                    get_json_widget_refresh_event(self.context, self.request,
                                                  SimpleHeaderPropertiesEditForm, 'logo'))
        return output


#
# Header menus table view
#

@adapter_config(name='simple-header-menus',
                context=(ISimpleHeaderRendererSettings, IPyAMSLayer, HeaderSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++menus', context=(ISimpleHeaderMenusContainer, IPyAMSLayer), provides=IMenusView)
class SimpleHeaderMenusView(MenusView):
    """Simple header menus view"""

    title = _("Top menus")

    table_class = MenusTable
    weight = 10
