#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface, Attribute
from zope.schema import Bool

from pyams_content.features.header.interfaces import IHeaderRendererSettings
from pyams_file.schema import ImageField
from pyams_sequence.schema import InternalReferenceField

from pyams_default_theme import _


PYAMS_HEADER_TEMPLATE_NAME_KEY = 'pyams.header.template_name'
"""Request annotations key used to define a custom header renderer template name"""

PYAMS_HEADER_MAIN_CLASS_KEY = 'pyams.header.main_class'
PYAMS_HEADER_TITLE_MAIN_CLASS_KEY = 'pyams.header.title.main_class'
PYAMS_HEADER_TITLE_INNER_CLASS_KEY = 'pyams.header.title.inner_class'
PYAMS_HEADER_NAVIGATION_MAIN_CLASS_KEY = 'pyams.header.navigation.main_class'
PYAMS_HEADER_NAVIGATION_INNER_CLASS_KEY = 'pyams.header.navigation.inner_class'


class ISimpleHeaderRendererSettings(IHeaderRendererSettings):
    """Simple header renderer settings"""

    apply_on_root = Bool(title=_("Apply on root?"),
                         description=_("If 'no', header settings will not be applied on site "
                                       "root but only on inner sites"),
                         required=True,
                         default=True)

    banner = ImageField(title=_("Banner image"),
                        description=_("Image displayed as header background"),
                        required=False)

    logo = ImageField(title=_("Logo"),
                      description=_("Logo displayed in header"),
                      required=False)

    search_target = InternalReferenceField(title=_("Search form target"),
                                           description=_("Site or folder handling site search"),
                                           required=False)

    tabs = Attribute("Top tabs list")

    menus = Attribute("Top tabs menus list")


class ISimpleHeaderMenusContainer(Interface):
    """Simple header menus marker interface"""
