#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.view import view_config

from pyams_content.component.theme import ITagsManager
from pyams_content.root import ISiteRoot
from pyams_default_theme.features.sitemap import ISitemapExtension
from pyams_skin.layer import IPyAMSUserLayer
from pyams_thesaurus.interfaces.thesaurus import IThesaurus
from pyams_utils.adapter import ContextRequestAdapter, adapter_config
from pyams_utils.registry import query_utility


@adapter_config(name='glossary',
                context=(ISiteRoot, IPyAMSUserLayer),
                provides=ISitemapExtension)
class SiteRootGlossarySitemap(ContextRequestAdapter):
    """Site root glossary sitemap extension"""

    @property
    def source(self):
        tags_manager = ITagsManager(self.context)
        if tags_manager.enable_glossary:
            thesaurus = query_utility(IThesaurus, name=tags_manager.glossary_thesaurus_name)
            if thesaurus is not None:
                return thesaurus


@view_config(name='sitemap.xml',
             context=IThesaurus, request_type=IPyAMSUserLayer,
             renderer='templates/glossary-sitemap.pt')
class GlossarySitemapView(object):
    """Glossary sitemap view"""

    def __init__(self, request):
        self.request = request

    def __call__(self):
        self.request.response.content_type = 'text/xml'
        return {}
