#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from z3c.form import field

from pyams_content.features.footer.zmi import FooterSettingsRendererSettingsEditForm
from pyams_content.features.menu.zmi import IMenusView, MenusTable, MenusView
from pyams_default_theme.features.footer.interfaces import ISimpleFooterRendererSettings, ISimpleFooterMenusContainer
from pyams_form.interfaces.form import IInnerSubForm
from pyams_portal.interfaces import MANAGE_TEMPLATE_PERMISSION
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm

from pyams_default_theme import _


@adapter_config(name='simple-footer-properties',
                context=(ISimpleFooterRendererSettings, IPyAMSLayer, FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
class SimpleFooterPropertiesEditForm(InnerAdminEditForm):
    """Simple footer properties edit form"""

    legend = None
    edit_permission = MANAGE_TEMPLATE_PERMISSION
    weight = 1

    fields = field.Fields(ISimpleFooterRendererSettings)


#
# Footer menus table view
#

@adapter_config(name='simple-footer-menus',
                context=(ISimpleFooterRendererSettings, IPyAMSLayer, FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++menus', context=(ISimpleFooterMenusContainer, IPyAMSLayer), provides=IMenusView)
class SimpleFooterTabsView(MenusView):
    """Simple footer links view"""

    title = _("Footer menus")

    table_class = MenusTable
    weight = 10
