#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.features.footer.interfaces import IFooterRendererSettings

# import packages
from zope.interface import Interface, Attribute
from zope.schema import TextLine

from pyams_default_theme import _


class ISimpleFooterRendererSettings(IFooterRendererSettings):
    """Simple footer renderer settings"""

    copyright = TextLine(title=_("Copyright"),
                         description=_("Copyright mention displayed in page footer"),
                         required=False)

    menus = Attribute("Footer links")


class ISimpleFooterMenusContainer(Interface):
    """Simple footer menus marker interface"""
