#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent import Persistent
from zope.interface import implementer
from zope.location import Location
from zope.location.interfaces import ISublocations
from zope.schema.fieldproperty import FieldProperty

from pyams_content.component.association.interfaces import ASSOCIATION_CONTAINER_KEY
from pyams_content.features.footer.interfaces import IFooterSettings, IFooterTarget
from pyams_content.features.menu.interfaces import IMenusContainer, IMenusContainerTarget
from pyams_default_theme.features.footer.interfaces import ISimpleFooterMenusContainer, ISimpleFooterRendererSettings
from pyams_default_theme.layer import IPyAMSDefaultLayer
from pyams_utils.adapter import ContextAdapter, adapter_config, get_annotation_adapter
from pyams_utils.traversing import get_parent
from pyams_viewlet.viewlet import ViewContentProvider, contentprovider_config


@contentprovider_config(name='pyams.footer', layer=IPyAMSDefaultLayer)
class FooterContentProvider(ViewContentProvider):
    """Footer content provider"""

    footer = None
    renderer = None

    def update(self):
        parent = get_parent(self.context, IFooterTarget)
        if parent is not None:
            footer = self.footer = IFooterSettings(parent, None)
            if footer is not None:
                renderer = self.renderer = footer.get_renderer(self.request)
                if renderer is not None:
                    renderer.update()

    def render(self, template_name=''):
        if self.footer is None:
            return ''
        renderer = self.footer.get_renderer(self.request)
        if renderer is None:
            return ''
        return renderer.render(template_name)


#
# Simple footer renderer settings
#

SIMPLE_FOOTER_MENUS_KEY = '{0}::menus'.format(ASSOCIATION_CONTAINER_KEY)


@implementer(ISimpleFooterRendererSettings, IMenusContainerTarget)
class SimpleFooterRendererSettings(Persistent, Location):
    """Simple footer renderer settings"""

    copyright = FieldProperty(ISimpleFooterRendererSettings['copyright'])

    @property
    def menus(self):
        return get_annotation_adapter(self, SIMPLE_FOOTER_MENUS_KEY, IMenusContainer,
                                      markers=ISimpleFooterMenusContainer, name='++ass++menus')


@adapter_config(name='menus', context=ISimpleFooterRendererSettings, provides=IMenusContainer)
def simple_footer_menus_adapter(context):
    """Simple footer menus adapter"""
    return context.menus


@adapter_config(name='menus', context=ISimpleFooterRendererSettings, provides=ISublocations)
class SimpleFooterRendererSettingsSublocations(ContextAdapter):
    """Simple footer renderer settings sub-locations adapter"""

    def sublocations(self):
        return self.context.menus.values()
