#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.video.interfaces import IExternalVideoParagraph, IExternalVideoRenderer
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.registry import get_current_registry

from pyams_default_theme import _


#
# External video paragraph default renderer
#

@adapter_config(name='default', context=(IExternalVideoParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/external-video-default.pt', layer=IPyAMSLayer)
class ExternalVideoParagraphDefaultRenderer(BaseContentRenderer):
    """external video paragraph default renderer"""

    label = _("Default video renderer")

    context_attrs = ('author',)
    i18n_context_attrs = ('title', 'description')

    video_renderer = None

    def __init__(self, context, request):
        super(ExternalVideoParagraphDefaultRenderer, self).__init__(context, request)
        provider = context.get_provider()
        if provider is not None:
            registry = get_current_registry()
            self.video_renderer = registry.queryMultiAdapter((context.settings, request), IExternalVideoRenderer)

    def update(self):
        super(ExternalVideoParagraphDefaultRenderer, self).update()
        renderer = self.video_renderer
        if renderer is not None:
            renderer.update()

    def render_video(self):
        renderer = self.video_renderer
        if not renderer:
            return ''
        return renderer.render()
