#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.schema import Bool, Choice
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from pyams_default_theme import _


FRAME_POSITIONS = (
    {'id': 'left', 'title': _("Left")},
    {'id': 'right', 'title': _("Right")},
    {'id': 'center', 'title': _("Center (full width)")}
)

FRAME_POSITIONS_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                               for item in FRAME_POSITIONS])


class IBaseVerbatimParagraphRendererSettings(Interface):
    """Base verbatim paragraph renderer settings interface"""

    zoom_on_click = Bool(title=_("Zoom on image click?"),
                         description=_("If 'yes', a click on illustration thumbnail is "
                                       "required to zoom"),
                         required=True,
                         default=True)


class IVerbatimParagraphRendererSettings(IBaseVerbatimParagraphRendererSettings):
    """Default verbatim paragraph renderer settings interface"""

    xs_horizontal_padding = Choice(title=_("XS horizontal padding"),
                                   description=_("Define horizontal padding for smartphones"),
                                   required=False,
                                   values=list(range(5)))

    sm_horizontal_padding = Choice(title=_("SM horizontal padding"),
                                   description=_("Define hoirzontal padding for tablets"),
                                   required=False,
                                   values=list(range(5)))

    md_horizontal_padding = Choice(title=_("MD horizontal padding"),
                                   description=_("Define horizontal padding for medium screens"),
                                   required=False,
                                   values=list(range(5)))

    lg_horizontal_padding = Choice(title=_("LG horizontal padding"),
                                   description=_("Define horizontal padding for large screens"),
                                   required=False,
                                   values=list(range(5)))

    def has_padding(self):
        """Check if any padding is defined"""


class ILateralVerbatimParagraphRendererSettings(IBaseVerbatimParagraphRendererSettings):
    """Verbatim paragraph lateral renderer settings interface"""

    relative_width = Choice(title=_("Relative width"),
                            description=_("Relative width used by this paragraph, relative "
                                          "to it's parent, given as columns count; full width "
                                          "counts for 12 columns"),
                            required=True,
                            values=list(range(1, 13)),
                            default=6)
