#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

# import standard library

# import interfaces
from pyams_content.component.paragraph.interfaces.frame import IFrameParagraph

# import packages
from pyams_content.features.renderer.zmi import RendererPropertiesEditForm
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.reference.pictograms.zmi.widget import PictogramSelectFieldWidget
from pyams_form.form import ajax_config
from pyams_skin.layer import IPyAMSLayer
from pyams_pagelet.pagelet import pagelet_config
from pyramid.decorator import reify


@pagelet_config(name='renderer-properties.html', context=IFrameParagraph, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='renderer-properties.json', context=IFrameParagraph, layer=IPyAMSLayer)
class FrameParagraphRendererPropertiesEditForm(RendererPropertiesEditForm):
    """Frame paragraph renderer properties edit form"""

    dialog_class = 'modal-large'

    @reify
    def fields(self):
        fields = super(FrameParagraphRendererPropertiesEditForm, self).fields
        if 'pictogram_name' in fields:
            fields['pictogram_name'].widgetFactory = PictogramSelectFieldWidget
        return fields
