#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid.decorator import reify

from pyams_content.component.paragraph.interfaces.contact import IContactParagraph, have_gis
from pyams_content.features.renderer.zmi import RendererPropertiesEditForm
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.form import ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer


@pagelet_config(name='renderer-properties.html', context=IContactParagraph, layer=IPyAMSLayer,
                permission=MANAGE_CONTENT_PERMISSION)
@ajax_config(name='renderer-properties.json', context=IContactParagraph, layer=IPyAMSLayer)
class ContactParagraphRendererPropertiesEditForm(RendererPropertiesEditForm):
    """Contact paragraph renderer properties edit form"""

    dialog_class = 'modal-large'

    @reify
    def fields(self):
        fields = super(ContactParagraphRendererPropertiesEditForm, self).fields
        if not have_gis:
            fields = fields.omit('display_map', 'map_position')
        return fields
