#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid.decorator import reify

from pyams_content.component.paragraph.interfaces.milestone import IMilestoneContainer, \
    IMilestoneParagraph
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


#
# Milestone paragraph default renderer
#

@adapter_config(name='default', context=(IMilestoneParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/milestone-default.pt', layer=IPyAMSLayer)
class DefaultMilestoneParagraphRenderer(BaseContentRenderer):
    """Default Pictogram renderer"""

    label = _("Default milestones renderer")
    weight = 1

    i18n_context_attrs = ('title', 'body')

    @reify
    def milestones(self):
        return IMilestoneContainer(self.context)

    @property
    def has_pictograms(self):
        for milestone in self.milestones.values():
            if milestone.pictogram is not None:
                return True
        return False

    @property
    def has_anchors(self):
        for milestone in self.milestones.values():
            if milestone.anchor is not None:
                return True
        return False
