#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.paragraph.interfaces.keypoint import IKeypointsParagraph
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

from pyams_default_theme import _


#
# Key points paragraph default renderer
#

@adapter_config(name='default', context=(IKeypointsParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/keypoints-default.pt', layer=IPyAMSLayer)
class KeypointsParagraphDefaultRenderer(BaseContentRenderer):
    """Key points paragraph default renderer"""

    label = _("Default key points renderer")

    i18n_context_attrs = ('title', 'body', )

    @property
    def keypoints(self):
        return self.body.split('\n') if self.body else ''
