#
# Copyright (c) 2015-2020 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_default_theme.component  module

"""

from zope.interface import Interface
from zope.schema import Bool, Choice
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from pyams_content.shared.logo import LOGO_CONTENT_TYPE
from pyams_default_theme.shared.logo.interfaces import EXTERNAL_FIRST, TARGET_PRIORITY_VOCABULARY
from pyams_sequence.interfaces import IInternalReference
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from pyams_default_theme import _


HTML_PARAGRAPH_DEFAULT_RENDERER_SETTINGS_KEY = 'pyams_content.html.renderer:default'


class IHTMLParagraphDefaultRendererSettings(Interface):
    """HTML paragraph default renderer settings"""

    xs_horizontal_padding = Choice(title=_("XS horizontal padding"),
                                   description=_("Define horizontal padding for smartphones"),
                                   required=False,
                                   values=list(range(5)))

    sm_horizontal_padding = Choice(title=_("SM horizontal padding"),
                                   description=_("Define hoirzontal padding for tablets"),
                                   required=False,
                                   values=list(range(5)))

    md_horizontal_padding = Choice(title=_("MD horizontal padding"),
                                   description=_("Define horizontal padding for medium screens"),
                                   required=False,
                                   values=list(range(5)))

    lg_horizontal_padding = Choice(title=_("LG horizontal padding"),
                                   description=_("Define horizontal padding for large screens"),
                                   required=False,
                                   values=list(range(5)))

    def has_padding(self):
        """Check if any padding is defined"""


ABOVE_ALIGN = 'above'
LEFT_ALIGN = 'left'
RIGHT_ALIGN = 'right'
BELOW_ALIGN = 'below'

LOGO_POSITION = (
    {'id': ABOVE_ALIGN, 'title': _("Centered above text")},
    {'id': LEFT_ALIGN, 'title': _("Left aligned (default)")},
    {'id': RIGHT_ALIGN, 'title': _("Right aligned")},
    {'id': BELOW_ALIGN, 'title': _("Centered below text")}
)

LOGO_POSITION_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                             for item in LOGO_POSITION])


class IHTMLParagraphWithLogosRendererSettings(IInternalReference):
    """HTML paragraph with logos renderer settings interface"""

    reference = InternalReferenceField(title=_("Selected logo"),
                                       description=_("Selected logo. You can "
                                                     "search a reference using '+' followed by "
                                                     "internal number, of by entering text "
                                                     "matching content title."),
                                       content_type=LOGO_CONTENT_TYPE,
                                       required=True)

    position = Choice(title=_("Logo position"),
                      required=True,
                      vocabulary=LOGO_POSITION_VOCABULARY,
                      default=LEFT_ALIGN)

    target_priority = Choice(title=_("Links priority"),
                             description=_("Order in which internal and external links are "
                                           "evaluated on logo"),
                             required=True,
                             vocabulary=TARGET_PRIORITY_VOCABULARY,
                             default=EXTERNAL_FIRST)

    force_canonical_url = Bool(title=_("Force canonical URL"),
                               description=_("By default, internal links use a \"relative\" URL, "
                                             "which tries to display link target in the current "
                                             "context; by using a canonical URL, you can display "
                                             "target in it's attachment context (if defined)"),
                               required=False,
                               default=False)
