#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Attribute, Interface
from zope.schema import Bool, Choice
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from pyams_content.reference.pictograms.interfaces import SELECTED_PICTOGRAM_VOCABULARY

from pyams_default_theme import _


FRAME_POSITIONS = (
    {'id': 'left', 'title': _("Left")},
    {'id': 'right', 'title': _("Right")},
    {'id': 'center', 'title': _("Center (full width)")}
)

FRAME_POSITIONS_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                               for item in FRAME_POSITIONS])


class IFrameParagraphRendererSettings(Interface):
    """Framed paragraph default renderer settings interface"""

    display_associations = Bool(title=_("Show associations?"),
                                description=_("If 'no', associations will not be displayed"),
                                required=True,
                                default=True)

    def can_display_associations(self):
        """Check if associations can be displayed"""

    pictogram_name = Choice(title=_("Pictogram"),
                            description=_("Name of the pictogram associated with this frame paragraph"),
                            required=False,
                            vocabulary=SELECTED_PICTOGRAM_VOCABULARY)

    pictogram = Attribute("Selected pictogram object")


class IDefaultFrameParagraphRendererSettings(IFrameParagraphRendererSettings):
    """Framed paragraph default renderer settings interface"""


class ILateralFrameParagraphRendererSettings(IFrameParagraphRendererSettings):
    """Framed paragraph lateral renderer settings interface"""

    relative_width = Choice(title=_("Relative width"),
                            description=_("Relative width used by this frame, relative to it's parent, "
                                          "given as columns count; full width counts for 12 columns"),
                            required=True,
                            values=list(range(1, 13)),
                            default=4)


class ILeftFrameParagraphRendererSettings(ILateralFrameParagraphRendererSettings):
    """Framed paragraph left renderer settings interface"""


class IRightFrameParagraphRendererSettings(ILateralFrameParagraphRendererSettings):
    """Framed paragraph right renderer settings interface"""
