#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Attribute, Interface
from zope.schema import Bool, Choice
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from pyams_i18n.schema import I18nTextLineField

from pyams_default_theme import _


CONTENT_POSITIONS = (
    {'id': 'left', 'title': _("Left")},
    {'id': 'right', 'title': _("Right")}
)

CONTENT_POSITIONS_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                                for item in CONTENT_POSITIONS])


class IContactParagraphDefaultRendererSettings(Interface):
    """Contact paragraph default renderer settings interface"""

    display_photo = Bool(title=_("Show photo?"),
                         description=_("Display contact photo"),
                         required=True,
                         default=True)

    photo_position = Choice(title=_("Photo position"),
                            required=False,
                            vocabulary=CONTENT_POSITIONS_VOCABULARY,
                            default='left')

    can_display_photo = Attribute("Check if photo can be displayed")

    display_map = Bool(title=_("Show location map?"),
                       description=_("If 'no', location map will not be displayed"),
                       required=True,
                       default=True)

    display_coordinates = Bool(title=_("Display location coordinates?"),
                               description=_("If 'no', location coordinates will not be "
                                             "displayed"),
                               required=True,
                               default=True)

    display_marker = Bool(title=_("Display location marker?"),
                          description=_("If 'no', location marker will be hidden"),
                          required=True,
                          default=True)

    map_position = Choice(title=_("Map position"),
                          required=False,
                          vocabulary=CONTENT_POSITIONS_VOCABULARY,
                          default='right')

    can_display_map = Attribute("Check if location map can be displayed")

    button_label = I18nTextLineField(title=_("Contact button label"),
                                     description=_("Custom label of the contact button displayed by "
                                                   "front-office template"),
                                     required=False)
