#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.paragraph import IParagraphContainer, IParagraphContainerTarget
from pyams_content.component.paragraph.interfaces import IParagraphRenderer
from pyams_content.features.renderer.interfaces import ISharedContentRenderer
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config


@adapter_config(name='paragraphs-render', context=(IParagraphContainerTarget, IPyAMSLayer),
                provides=ISharedContentRenderer)
class ParagraphsContainerRenderer(BaseContentRenderer):
    """Paragraphs container renderer"""

    weight = 10

    def __init__(self, context, request):
        super(ParagraphsContainerRenderer, self).__init__(context, request)
        paragraphs = [
            para for para in IParagraphContainer(self.context).values()
            if para.visible
        ]
        registry = self.request.registry
        self.renderers = [
            registry.queryMultiAdapter((paragraph, self.request), IParagraphRenderer)
            for paragraph in paragraphs
        ]

    def update(self):
        super(ParagraphsContainerRenderer, self).update()
        for renderer in self.renderers:
            if renderer is not None:
                renderer.language = self.language
                renderer.update()

    def render(self, template_name=''):
        result = ''
        for renderer in self.renderers:
            if renderer is not None:
                result += renderer.render(template_name)
        return result
