#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import implementer

from pyams_content.component.paragraph.interfaces import IBaseParagraph
from pyams_content.features.preview.interfaces import IPreviewView
from pyams_default_theme.layer import IPyAMSDefaultLayer
from pyams_default_theme.page import BasePreviewPage
from pyams_pagelet.pagelet import pagelet_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='preview.html', context=IBaseParagraph, layer=IPyAMSDefaultLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@implementer(IPreviewView)
class ParagraphPreviewPage(BasePreviewPage):
    """Paragraph preview page"""

    def __init__(self, context, request):
        super(ParagraphPreviewPage, self).__init__(context, request)
        self.language = request.params.get('lang')
        self.renderer = context.get_renderer(request)

    def update(self):
        super(ParagraphPreviewPage, self).update()
        if self.renderer is not None:
            self.renderer.language = self.language
            self.renderer.update()

    def render(self):
        if self.renderer is not None:
            return '<div class="edito">{}</div>'.format(self.renderer.render())
        else:
            return ''
