#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from z3c.form import field
    from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget

    from pyams_default_theme.component.map.interfaces import IMapParagraphDefaultRendererSettings
    from pyams_form.interfaces.form import IFormManager
    from pyams_form.manager import DialogEditFormFormManager
    from pyams_skin.layer import IPyAMSLayer
    from pyams_content.features.renderer.zmi import RendererPropertiesEditForm
    from pyams_form.group import NamedWidgetsGroup
    from pyams_utils.adapter import adapter_config
    from pyams_zmi.form import AdminDialogEditForm

    from pyams_default_theme import _


    @adapter_config(context=(IMapParagraphDefaultRendererSettings, IPyAMSLayer,
                             RendererPropertiesEditForm),
                    provides=IFormManager)
    class MapParagraphDefaultRendererSettingsFormManager(DialogEditFormFormManager):
        """Map paragraph default renderer settings form manager"""

        def getFields(self):
            fields = field.Fields(IMapParagraphDefaultRendererSettings).omit(
                'use_default_map_configuration')
            fields['no_use_default_map_configuration'].widgetFactory = SingleCheckBoxFieldWidget
            return fields

        def updateGroups(self):
            form = self.view
            form.add_group(NamedWidgetsGroup(form, 'configuration', form.widgets,
                                             list(form.fields.keys())[:-1],
                                             legend=_("Don't use default map configuration"),
                                             css_class='inner',
                                             switch=True,
                                             checkbox_switch=True,
                                             checkbox_field=IMapParagraphDefaultRendererSettings[
                                                 'no_use_default_map_configuration']))
            AdminDialogEditForm.updateGroups(form)
