#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from z3c.form.browser.checkbox import SingleCheckBoxFieldWidget
    from z3c.form.field import Fields

    from pyams_default_theme.component.map.portlet import IMapPortletDefaultRendererSettings
    from pyams_form.group import NamedWidgetsGroup
    from pyams_form.interfaces.form import IFormManager
    from pyams_form.manager import DialogEditFormFormManager
    from pyams_portal.zmi.portlet import PortletRendererPropertiesEditForm
    from pyams_skin.layer import IPyAMSLayer
    from pyams_utils.adapter import adapter_config
    from pyams_zmi.form import AdminDialogEditForm

    from pyams_default_theme import _


    @adapter_config(context=(IMapPortletDefaultRendererSettings, IPyAMSLayer,
                             PortletRendererPropertiesEditForm),
                    provides=IFormManager)
    class MapPortletDefaultRendererSettingsFormManager(DialogEditFormFormManager):
        """Map portlet default renderer properties edit form"""

        def getFields(self):
            fields = Fields(IMapPortletDefaultRendererSettings).omit('use_default_map_configuration')
            fields['no_use_default_map_configuration'].widgetFactory = SingleCheckBoxFieldWidget
            return fields

        def updateGroups(self):
            view = self.view
            view.add_group(NamedWidgetsGroup(view, 'configuration', view.widgets,
                                             list(view.fields.keys()),
                                             legend=_("Don't use default map configuration"),
                                             css_class='inner',
                                             switch=True,
                                             checkbox_switch=True,
                                             checkbox_field=IMapPortletDefaultRendererSettings[
                                                 'no_use_default_map_configuration']))
            AdminDialogEditForm.updateGroups(view)
