#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    import json

    from zope.interface import Interface

    from pyams_content.component.map.portlet import IMapPortletSettings
    from pyams_default_theme.component.map import BaseMapRendererSettings
    from pyams_default_theme.component.map.portlet.interfaces import \
        IMapPortletDefaultRendererSettings
    from pyams_portal.interfaces import IPortalContext, IPortletRenderer
    from pyams_portal.portlet import PortletRenderer
    from pyams_skin.layer import IPyAMSLayer
    from pyams_template.template import template_config
    from pyams_utils.adapter import adapter_config
    from pyams_utils.factory import factory_config

    from pyams_default_theme import _


    @factory_config(IMapPortletDefaultRendererSettings)
    class MapPortletDefaultRendererSettings(BaseMapRendererSettings):
        """Map portlet default renderer settings"""


    @adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IMapPortletSettings),
                    provides=IPortletRenderer)
    @template_config(template='templates/map-default.pt', layer=IPyAMSLayer)
    class MapPortletDefaultRenderer(PortletRenderer):
        """Map portlet default renderer"""

        label = _("Simple location map")
        weight = 1

        settings_interface = IMapPortletDefaultRendererSettings

        def get_map_configuration(self):
            configuration = self.renderer_settings.configuration
            if self.settings.gps_location and self.settings.display_marker:
                coordinates = self.settings.gps_location.wgs_coordinates
                configuration['marker'] = {
                    'lat': float(coordinates[1]),
                    'lon': float(coordinates[0])
                }
            return json.dumps(configuration)
